#!/bin/bash

if [ ! -n "$1" ]; then
	echo "usage: <cmd> app_name"
	echo "app_name      the app's name, e.g. 'My Sample App.app'"
	exit 1
fi

dockplistfile="${HOME}/Library/Preferences/com.apple.dock.plist"

APPNAME=$1
APPNAME_SHORT=$(basename -s .app "$APPNAME")

# find the indices
indices=$(/usr/libexec/PlistBuddy -c "Print :persistent-apps" "${dockplistfile}" | /usr/bin/awk -F '=' '/file-label = /{print $2}' | /usr/bin/nl -v 0 | /usr/bin/grep -i "$APPNAME_SHORT" | /usr/bin/awk '{print $1}' | /usr/bin/sort -rn)

if [[ -z "${indices}" ]]; then
	echo "no dock app found"
	exit 0
fi

# remove entries
for index in ${indices}; do
	echo "removing index ${index}"
	/usr/libexec/PlistBuddy -c "Delete :persistent-apps:'${index}'" "${dockplistfile}"
done

# remove entries
#for index in ${indices}; do
#	echo "removing index ${index}"
#	/usr/libexec/PlistBuddy -c "Print :persistent-apps:'${index}'" "${dockplistfile}"
#done

# save and restart
/usr/libexec/PlistBuddy -c save "${dockplistfile}"
/usr/bin/killall -HUP Dock

